/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.baidu.speech.EventListener;
import com.baidu.speech.EventManager;
import com.baidu.speech.aidl.EventListener;
import com.baidu.speech.aidl.EventManagerFactory;
import com.baidu.speech.aidl.EventRecognitionService;
import com.baidu.speech.asr.EventManagerAsr;
import com.baidu.speech.asr.EventManagerSlot;
import com.baidu.speech.asr.EventManagerWp;
import com.baidu.speech.audio.MicrophoneServer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class EventManagerFactory {
    private static final String TAG = "EventManagerFactory";
    private static boolean kwsLoaded = false;
    private static boolean asrUsing = false;
    private static boolean wpUsing = false;

    public static final EventManager create(Context context, String string) {
        return EventManagerFactory.create(context, string, false);
    }

    public static final EventManager create(Context context, String string, boolean bl) {
        if (context == null || string == null || string.equals("")) {
            return null;
        }
        context = context.getApplicationContext();
        if (bl) {
            EventManagerRemote2Local eventManagerRemote2Local = new EventManagerRemote2Local(context, string);
            return eventManagerRemote2Local;
        }
        if (string.equals("asr")) {
            return new EventManagerAsr(context);
        }
        if (string.equals("wp")) {
            return new EventManagerWp(context);
        }
        if (string.equals("slot")) {
            return new EventManagerSlot(context);
        }
        return null;
    }

    static class EventManagerRemote2Local
    implements EventManager {
        private com.baidu.speech.aidl.EventManager remoteEM;
        private Context context;
        private String name;
        ExecutorService executor = Executors.newCachedThreadPool();
        final ServiceConnection conn = new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                com.baidu.speech.aidl.EventManagerFactory eventManagerFactory = EventManagerFactory.Stub.asInterface(iBinder);
                try {
                    if (null == EventManagerRemote2Local.this.remoteEM) {
                        com.baidu.speech.aidl.EventManager eventManager = eventManagerFactory.create(EventManagerRemote2Local.this.name);
                        EventManagerRemote2Local.this.setRemoteEM(eventManager);
                    }
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }

            public void onServiceDisconnected(ComponentName componentName) {
                if (kwsLoaded && EventManagerRemote2Local.this.mLis != null) {
                    EventManagerRemote2Local.this.mLis.onEvent("asr.unloaded", null, null, 0, 0);
                }
                if (asrUsing && EventManagerRemote2Local.this.mLis != null) {
                    EventManagerRemote2Local.this.mLis.onEvent("asr.exit", null, null, 0, 0);
                }
                if (wpUsing && EventManagerRemote2Local.this.mLis != null) {
                    EventManagerRemote2Local.this.mLis.onEvent("wp.exit", null, null, 0, 0);
                }
                EventManagerRemote2Local.this.remoteEM = null;
            }
        };
        private EventListener mLis;

        EventManagerRemote2Local(Context context, String string) {
            this.context = context;
            this.name = string;
        }

        public void setRemoteEM(com.baidu.speech.aidl.EventManager eventManager) {
            this.remoteEM = eventManager;
        }

        public void send(final String string, final String string2, byte[] byArray, final int n, final int n2) {
            byte[] byArray2;
            this.context.bindService(new Intent(this.context, EventRecognitionService.class), this.conn, 1);
            byte[] byArray3 = byArray2 = byArray == null ? new byte[]{} : byArray;
            if ("asr.start".equals(string) || "asr.kws.load".equals(string)) {
                asrUsing = true;
            } else if ("wp.start".equals(string)) {
                wpUsing = true;
            } else if ("asr.kws.load".equals(string)) {
                kwsLoaded = true;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    if (null == EventManagerRemote2Local.this.remoteEM) {
                        new Handler(Looper.getMainLooper()).postDelayed((Runnable)this, 10L);
                        return;
                    }
                    String string3 = string2;
                    if ("asr.start".equals(string) || "wp.start".equals(string)) {
                        JSONObject jSONObject;
                        try {
                            jSONObject = new JSONObject(string2);
                        }
                        catch (Exception exception) {
                            jSONObject = new JSONObject();
                        }
                        try {
                            String string22 = jSONObject.optString("infile");
                            if (!jSONObject.has("audio.socketport") && !TextUtils.isEmpty((CharSequence)string22)) {
                                int n3 = 1;
                                if (jSONObject.has("audio.source")) {
                                    n3 = jSONObject.optInt("audio.source");
                                }
                                int n22 = MicrophoneServer.create(string22, n3);
                                jSONObject.put("audio.socketport", n22);
                                string3 = jSONObject.toString();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    try {
                        EventManagerRemote2Local.this.remoteEM.registerListener(new EventListener.Stub(){

                            public void onEvent(final String string, final String string2, final byte[] byArray, final int n, final int n2) throws RemoteException {
                                if ("asr.exit".equals(string)) {
                                    asrUsing = false;
                                } else if ("wp.exit".equals(string)) {
                                    wpUsing = false;
                                } else if ("asr.unloaded".equals(string)) {
                                    kwsLoaded = false;
                                }
                                if ("wp.exit".equals(string)) {
                                    JSONObject jSONObject = null;
                                    boolean bl = false;
                                    try {
                                        jSONObject = new JSONObject(string2 == null ? "{}" : string2);
                                        bl = jSONObject.optBoolean("_free");
                                        jSONObject.remove("_free");
                                    }
                                    catch (JSONException jSONException) {
                                        jSONException.printStackTrace();
                                    }
                                    final String string3 = jSONObject.toString();
                                    if (bl) {
                                        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                                            public void run() {
                                                EventManagerRemote2Local.this.mLis.onEvent(string, string3, byArray, n, n2);
                                            }
                                        }, 200L);
                                    } else {
                                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                                            public void run() {
                                                EventManagerRemote2Local.this.mLis.onEvent(string, string3, byArray, n, n2);
                                            }
                                        });
                                    }
                                } else {
                                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                                        public void run() {
                                            EventManagerRemote2Local.this.mLis.onEvent(string, string2, byArray, n, n2);
                                        }
                                    });
                                }
                            }
                        });
                        EventManagerRemote2Local.this.remoteEM.send(string, string3, byArray2, n, n2);
                    }
                    catch (RemoteException remoteException) {
                        remoteException.printStackTrace();
                        EventManagerRemote2Local.this.remoteEM = null;
                    }
                }
            };
            new Handler(Looper.getMainLooper()).postDelayed(runnable, 0L);
        }

        public void registerListener(EventListener eventListener) {
            this.mLis = eventListener;
        }

        public void unregisterListener(EventListener eventListener) {
            this.mLis = null;
        }
    }
}

