/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.asr;

import android.content.Context;
import android.util.Log;
import com.baidu.speech.EventListener;
import com.baidu.speech.EventManager;
import com.baidu.speech.asr.ASRListener;
import com.baidu.speech.utils.analysis.Analysis;
import org.json.JSONObject;

public class AnalysisInterceptor
implements EventManager,
ASRListener {
    private static final boolean DEBUG = false;
    private static AnalysisInterceptor instance;
    private static final String TAG = "Analysis";
    private final Context context;
    private Analysis.Item usingAnalysisItem;

    public AnalysisInterceptor(Context context) {
        this.context = context;
    }

    public static synchronized AnalysisInterceptor getInstance(Context context) {
        if (null == instance) {
            instance = new AnalysisInterceptor(context.getApplicationContext());
        }
        return instance;
    }

    public void send(String string, String string2, byte[] byArray, int n, int n2) {
        try {
            JSONObject jSONObject;
            if ("asr.start".equals(string)) {
                jSONObject = new JSONObject(string2);
                int n3 = jSONObject.optInt("appid", 0);
                this.usingAnalysisItem = new Analysis.Item();
                this.usingAnalysisItem.appId = n3;
                this.usingAnalysisItem.pkg = this.context.getPackageName();
                this.usingAnalysisItem.time = System.currentTimeMillis();
                int n4 = jSONObject.optInt("vad.endpoint-timeout", -1);
                String string3 = this.usingAnalysisItem.type = n4 == 0 ? "asr_longspeech" : "asr_normal";
            }
            if ("wp.start".equals(string)) {
                jSONObject = new JSONObject(string2);
                Analysis.Item item = new Analysis.Item();
                item.pid = 0;
                item.error_code = 0;
                item.appId = jSONObject.getInt("appid");
                item.time = System.currentTimeMillis();
                item.pkg = this.context.getPackageName();
                item.type = "wakeup";
                Analysis.log(this.context, item);
                Analysis.asyncUploadAll(this.context);
            }
        }
        catch (Exception exception) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.w((String)TAG, (String)"", (Throwable)exception);
            }
            exception.printStackTrace();
        }
    }

    public void registerListener(EventListener eventListener) {
    }

    public void unregisterListener(EventListener eventListener) {
    }

    public void onEvent(String string, String string2, byte[] byArray, int n, int n2, boolean bl) {
        try {
            JSONObject jSONObject;
            if ("asr.ready".equals(string)) {
                int n3;
                int n4;
                jSONObject = new JSONObject(string2);
                this.usingAnalysisItem.pid = n4 = jSONObject.getInt("pid");
                this.usingAnalysisItem.decoder = n3 = jSONObject.optInt("decoder-server.decoder", jSONObject.optInt("decoder", 0));
            }
            if ("asr.finish".equals(string)) {
                jSONObject = new JSONObject(string2);
                this.usingAnalysisItem.error_code = jSONObject.optInt("sub_error", 0);
            }
            if ("asr.exit".equals(string)) {
                Analysis.log(this.context, this.usingAnalysisItem);
                Analysis.asyncUploadAll(this.context);
            }
        }
        catch (Exception exception) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"", (Throwable)exception);
            }
            exception.printStackTrace();
        }
    }

    public void onEvent(String string, String string2, byte[] byArray, int n, int n2) {
    }
}

