/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.asr;

import android.content.Context;
import com.baidu.speech.EventListener;
import com.baidu.speech.core.BDSErrorDescription;
import com.baidu.speech.core.BDSMessage;
import com.baidu.speech.core.BDSParamBase;
import com.baidu.speech.core.BDSSDKLoader;
import com.baidu.speech.utils.Policy;
import com.baidu.speech.utils.Utility;
import java.util.HashMap;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SlotControl
implements BDSSDKLoader.BDSCoreEventListener {
    private static final String UPLOADER_CMD_CONFIG = "uploader.config";
    private static final String UPLOADER_CMD_START = "uploader.start";
    private static final String UPLOADER_CMD_CANCEL = "uploader.cancel";
    private static final String UPLOADER_NET_STATUS_KEY = "upl_param_key_network_status.int";
    private static final String UPLOADER_SLOT_NAME_KEY = "upl_param_key_upload_slot_name.string";
    private static final String UPLOADER_WORDS_KEY = "upl_param_key_upload_words.vector<string>";
    private static final String UPLOADER_PRODUCT_ID = "upl_param_key_product_id.string";
    private static final String UPLOADER_URL = "upl_param_key_url.string";
    private static final String UPLOADER_CUID = "upl_param_key_cuid.string";
    private static String ASR_PARAM_KEY_SDK_VERSION = "asr_param_key_sdk_version.string";
    private static String ASR_PARAM_KEY_PLATFORM = "asr_param_key_platform.string";
    private static String ASR_PARAM_KEY_NETWORK_STATUS = "asr_param_key_network_status.int";
    private static final int UPLOADER_ERROR_CODE_OK = 0;
    private static final int UPLOADER_ERROR_CODE_PARAM_ERROR = 1;
    private static final int PLOADER_ERROR_CODE_REQUEST_ERROR = 2;
    private static final int UPLOADER_ERROR_CODE_RESPONSE_ERROR = 3;
    private static final int UPLOADER_ERROR_CODE_NET_UNAVAILAVLE = 4;
    private EventListener mListener;
    private Context context;
    private JSONObject mParams;
    private String outFile = null;
    private BDSSDKLoader.BDSSDKInterface m_Uploadcore;

    public SlotControl(Context context) throws Exception {
        this.context = context;
        try {
            BDSSDKLoader.loadLibraries();
        }
        catch (Exception exception) {
            throw new Exception("Can not load so library");
        }
        this.m_Uploadcore = BDSSDKLoader.getSDKObjectForSDKType("UploaderCore", context);
        if (this.m_Uploadcore == null) {
            throw new Exception("ASR core support is not linked in package");
        }
        if (!this.m_Uploadcore.instanceInitialized()) {
            throw new Exception("Failed initialize ASR Core native layer");
        }
        this.m_Uploadcore.setListener(this);
    }

    public BDSErrorDescription postEvent(String string, String string2) {
        BDSErrorDescription bDSErrorDescription = null;
        if (!this.m_Uploadcore.instanceInitialized()) {
            bDSErrorDescription = new BDSErrorDescription();
            bDSErrorDescription.errorCode = -1;
            bDSErrorDescription.errorDomain = 1;
            bDSErrorDescription.errorDescription = "JNI: ASR Core native layer is not initialized!";
            return bDSErrorDescription;
        }
        try {
            this.mParams = string2 == null || string2.equals("") ? new JSONObject() : new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            this.mParams = new JSONObject();
        }
        bDSErrorDescription = this.uploadSlotWords(bDSErrorDescription, this.mParams);
        if (bDSErrorDescription != null) {
            return bDSErrorDescription;
        }
        return this.postEvent(bDSErrorDescription, string);
    }

    private BDSErrorDescription postEvent(BDSErrorDescription bDSErrorDescription, String string) {
        BDSMessage bDSMessage = new BDSMessage();
        bDSMessage.m_messageName = string;
        bDSMessage.m_messageParams = new HashMap();
        String string2 = this.mParams.optString("decoder-server.app", Policy.app(this.context));
        String string3 = this.mParams.optString("pid");
        String string4 = this.mParams.optString("url", "https://upl.baidu.com//words/add");
        String string5 = this.mParams.optString("decoder-server.uid", Policy.uid(this.context));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_PLATFORM, BDSParamBase.objectParam("Android", "java.lang.String"));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_SDK_VERSION, BDSParamBase.objectParam("C++ ASR core", "java.lang.String"));
        bDSMessage.m_messageParams.put(UPLOADER_NET_STATUS_KEY, BDSParamBase.intParam(Utility.getWifiOr2gOr3G(this.context)));
        bDSMessage.m_messageParams.put(UPLOADER_PRODUCT_ID, BDSParamBase.objectParam(string3, "java.lang.String"));
        bDSMessage.m_messageParams.put(UPLOADER_URL, BDSParamBase.objectParam(string4, "java.lang.String"));
        bDSMessage.m_messageParams.put(UPLOADER_CUID, BDSParamBase.objectParam(string5, "java.lang.String"));
        int n = this.m_Uploadcore.postMessage(bDSMessage);
        if (n != 0) {
            bDSErrorDescription = new BDSErrorDescription();
            bDSErrorDescription.errorCode = -2;
            bDSErrorDescription.errorDomain = 1;
            bDSErrorDescription.errorDescription = "JNI: readyParamsAsrStart Call to Native layer returned error! err( " + n + " )";
            return bDSErrorDescription;
        }
        return bDSErrorDescription;
    }

    public void setListener(EventListener eventListener) {
        this.mListener = eventListener;
    }

    public void receiveCoreEvent(BDSMessage bDSMessage, BDSSDKLoader.BDSSDKInterface bDSSDKInterface) {
        if (this.mListener != null && bDSMessage != null) {
            this.asrCallBack(bDSMessage, this.mListener);
        }
    }

    private void asrCallBack(BDSMessage bDSMessage, EventListener eventListener) {
        if (bDSMessage.m_messageName.equals("UPLOAD.callback")) {
            int n = ((BDSParamBase.BDSIntParam)bDSMessage.m_messageParams.get((Object)"cb.error.domain.int16_t")).iValue;
            String string = (String)((BDSParamBase.BDSObjectParam)bDSMessage.m_messageParams.get((Object)"cb.error.desc.string")).iValue;
            int n2 = ((BDSParamBase.BDSIntParam)bDSMessage.m_messageParams.get((Object)"cb.error.code.int16_t")).iValue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("errorDomain", n);
            hashMap.put("errorCode", n2);
            hashMap.put("errorDesc", string);
            eventListener.onEvent("uploader.finish", new JSONObject(hashMap).toString(), null, 0, 0);
        }
    }

    private BDSErrorDescription uploadSlotWords(BDSErrorDescription bDSErrorDescription, JSONObject jSONObject) {
        String string = jSONObject.optString("name");
        JSONArray jSONArray = jSONObject.optJSONArray("words");
        if (this.m_Uploadcore.instanceInitialized()) {
            int n;
            BDSMessage bDSMessage = new BDSMessage();
            bDSMessage.m_messageName = UPLOADER_CMD_CONFIG;
            bDSMessage.m_messageParams = new HashMap();
            Vector<String> vector = new Vector<String>();
            if (jSONArray != null) {
                for (n = 0; n < jSONArray.length(); ++n) {
                    try {
                        vector.add(jSONArray.getString(n));
                        continue;
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
            }
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_PLATFORM, BDSParamBase.objectParam("Android", "java.lang.String"));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_SDK_VERSION, BDSParamBase.objectParam("C++ ASR core", "java.lang.String"));
            bDSMessage.m_messageParams.put(UPLOADER_NET_STATUS_KEY, BDSParamBase.intParam(Utility.getWifiOr2gOr3G(this.context)));
            bDSMessage.m_messageParams.put(UPLOADER_SLOT_NAME_KEY, BDSParamBase.objectParam(string, "java.lang.String"));
            bDSMessage.m_messageParams.put(UPLOADER_WORDS_KEY, BDSParamBase.objectParam(vector, "java.util.Vector;"));
            n = this.m_Uploadcore.postMessage(bDSMessage);
            if (n != 0) {
                bDSErrorDescription = new BDSErrorDescription();
                bDSErrorDescription.errorCode = -2;
                bDSErrorDescription.errorDomain = 1;
                bDSErrorDescription.errorDescription = "JNI: readyParamsAsrStart Call to Native layer returned error! err( " + n + " )";
                return bDSErrorDescription;
            }
        }
        return bDSErrorDescription;
    }
}

