/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.core;

import android.util.Log;
import com.baidu.speech.core.BDSHTTPResponse;
import com.baidu.speech.utils.CommonParam;
import com.baidu.speech.utils.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONObject;

public class BDSHttpRequestMaker {
    private static final String TAG = "BDSHttpRequestMaker";
    private static final Boolean DEBUG = true;
    private static SSLContext sSSLContext = null;
    private static final int TIMEOUT_DURATION = 10;
    private static final int CONNECTION_TIMEOUT = 3;
    private static final int TYPE_UPLOAD_PARAM = 0;
    private static final int TYPE_UPLOAD_AUDIO = 1;
    private static final int TYPE_UPLOAD_THIRD_DATA = 2;
    private static final int TYPE_UPLOAD_FINISH = 3;
    private static final int TYPE_UPLOAD_CANCEL = 4;
    private static final int TYPE_DOWNLOAD_PARTIAL = 240;
    private static final int TYPE_DOWNLOAD_FINAL = 241;
    private static final int TYPE_DOWNLOAD_THIRD_DATA = 242;
    private static final int TYPE_DOWNLOAD_FINISH = 243;
    private static final String BACKUP_URL_NORTH = "119.75.222.172";
    private static final String BACKUP_URL_SOUTH = "182.61.62.25";
    private boolean mRetriedNorth = false;
    private boolean mRetriedSouth = false;
    private String mNorthUpUrl;
    private String mNorthDownUrl;
    private String mSouthUpUrl;
    private String mSouthDownUrl;
    private final int CONNECTION_STATUS_INIT = 0;
    private final int CONNECTION_STATUS_WORKING = 1;
    private final int CONNECTION_STATUS_CLOSE = 2;
    private HttpURLConnection mUploadConnection = null;
    private HttpURLConnection mDownloadConnection = null;
    private OutputStream mUploadOutputStream = null;
    private DataInputStream mDownloadInputStream = null;
    private int mUploadConnctionStatus = 0;
    private int mDownloadConnectionStatus = 0;
    private MyUploadThread mUploadThread = new MyUploadThread();
    private ArrayList<BDSHTTPResponse> mErrorArray = new ArrayList();
    private boolean mUploadedData = false;
    private boolean mAgentUpload = false;
    private boolean mAgentDownload = false;
    private static String mHostIp = "";
    private static SSLSocketFactory defaultSslFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
    private static HostnameVerifier defaulthostVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
    final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        public boolean verify(String string, SSLSession sSLSession) {
            String string2 = BDSHttpRequestMaker.convertHostname(string);
            if (Log.isLoggable((String)BDSHttpRequestMaker.TAG, (int)3) || DEBUG.booleanValue()) {
                BDSHttpRequestMaker.this.logD(BDSHttpRequestMaker.TAG, "hostname : " + string + " verifyUrl : " + string2);
            }
            if (string2.equals("vse.baidu.com") || string2.equals("vop.baidu.com") || string2.equals("openapi.baidu.com") || string2.equals("audiotest.baidu.com") || string2.equals(BDSHttpRequestMaker.BACKUP_URL_NORTH) || string2.equals(BDSHttpRequestMaker.BACKUP_URL_SOUTH) || string2.equals("httpsdns.baidu.com") || string2.equals("upl.baidu.com")) {
                return true;
            }
            return string2.contains(".baidu.");
        }
    };

    public static BDSHttpRequestMaker newRequestMaker() {
        if (sSSLContext == null) {
            try {
                sSSLContext = SSLContext.getInstance("TLS");
                sSSLContext.init(null, null, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return new BDSHttpRequestMaker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public BDSHTTPResponse makeRequest(String string, byte[] byArray, String[] stringArray, float f, int n) {
        try {
            mHostIp = new URL(string).getHost();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n2 = 0;
        BDSHTTPResponse bDSHTTPResponse = new BDSHTTPResponse();
        long l = System.currentTimeMillis();
        while (true) {
            IOException iOException2222;
            Object var30_18;
            ByteArrayOutputStream byteArrayOutputStream;
            BufferedInputStream bufferedInputStream;
            HttpURLConnection httpURLConnection;
            block50: {
                Object object;
                int n3;
                URLConnection[] uRLConnectionArray;
                if (Log.isLoggable((String)TAG, (int)3) || DEBUG.booleanValue()) {
                    this.logD(TAG, "Begin request, url is " + string);
                }
                httpURLConnection = null;
                bufferedInputStream = null;
                byteArrayOutputStream = null;
                BufferedOutputStream bufferedOutputStream = null;
                if (System.currentTimeMillis() - l > 500L) {
                    throw new SocketTimeoutException();
                }
                URL uRL = new URL(string);
                long l2 = System.currentTimeMillis();
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                long l3 = System.currentTimeMillis();
                if (httpURLConnection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(this.DO_NOT_VERIFY);
                }
                for (int i = 0; stringArray != null && i < stringArray.length - 1; i += 2) {
                    httpURLConnection.setRequestProperty(stringArray[i], stringArray[i + 1]);
                }
                httpURLConnection.setDoInput(true);
                if (n == 1 && byArray != null) {
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setFixedLengthStreamingMode(byArray.length);
                    httpURLConnection.setReadTimeout(10000);
                    httpURLConnection.setConnectTimeout(8000);
                    uRLConnectionArray = new URLConnection[]{httpURLConnection};
                    Executors.newSingleThreadExecutor().submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            uRLConnectionArray[0].connect();
                            return null;
                        }
                    }).get(10L, TimeUnit.SECONDS);
                    bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
                    bufferedOutputStream.write(byArray);
                    bufferedOutputStream.close();
                } else {
                    httpURLConnection.setConnectTimeout((int)(f * 1000.0f));
                    httpURLConnection.setReadTimeout((int)(f * 1000.0f));
                }
                uRLConnectionArray = httpURLConnection.getInputStream();
                bufferedInputStream = new BufferedInputStream((InputStream)uRLConnectionArray);
                byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[16384];
                while ((n3 = bufferedInputStream.read(byArray2, 0, byArray2.length)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n3);
                }
                byteArrayOutputStream.flush();
                long l4 = System.currentTimeMillis();
                LogUtil.d("End request from java: url: " + string, new String[0]);
                LogUtil.d("http url: " + string, new String[0]);
                bDSHTTPResponse.m_response_data = byteArrayOutputStream.toByteArray();
                bDSHTTPResponse.m_http_status = httpURLConnection.getResponseCode();
                bDSHTTPResponse.m_request_status = 0;
                bDSHTTPResponse.m_log = "connect_time=" + (l3 - l2) + "&request-response_time=" + (l4 - l3);
                if (Log.isLoggable((String)TAG, (int)3) || DEBUG.booleanValue()) {
                    this.logD(TAG, "Receive response, data: " + new String(bDSHTTPResponse.m_response_data) + " httpStatus: " + bDSHTTPResponse.m_http_status);
                }
                try {
                    object = new String(bDSHTTPResponse.m_response_data);
                    if (!((String)object).startsWith("license_begin")) {
                        JSONObject jSONObject = new JSONObject((String)object);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bDSHTTPResponse.m_http_status = 2006;
                    bDSHTTPResponse.m_response_data = null;
                    bDSHTTPResponse.m_request_status = 0;
                }
                object = httpURLConnection.getHeaderFields();
                if (object.entrySet().size() > 0) {
                    bDSHTTPResponse.m_response_headers = new String[object.entrySet().size() * 2];
                    int n4 = 0;
                    for (Map.Entry entry : object.entrySet()) {
                        bDSHTTPResponse.m_response_headers[n4++] = entry.getKey() != null ? (String)entry.getKey() : "";
                        bDSHTTPResponse.m_response_headers[n4++] = ((List)entry.getValue()).get(0) != null ? (String)((List)entry.getValue()).get(0) : "";
                    }
                }
                var30_18 = null;
                if (null != httpURLConnection) {
                    httpURLConnection.disconnect();
                }
                if (bufferedInputStream == null) break block50;
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException2222) {
                    iOException2222.printStackTrace();
                }
                bufferedInputStream = null;
            }
            if (byteArrayOutputStream == null) break;
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException2222) {
                iOException2222.printStackTrace();
            }
            byteArrayOutputStream = null;
            {
                break;
                catch (SocketTimeoutException socketTimeoutException) {
                    socketTimeoutException.printStackTrace();
                    bDSHTTPResponse.m_http_status = 2005;
                    bDSHTTPResponse.m_request_status = 0;
                    var30_18 = null;
                    if (null != httpURLConnection) {
                        httpURLConnection.disconnect();
                    }
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException2222) {
                            iOException2222.printStackTrace();
                        }
                        bufferedInputStream = null;
                    }
                    if (byteArrayOutputStream == null) break;
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException2222) {
                        iOException2222.printStackTrace();
                    }
                    byteArrayOutputStream = null;
                    break;
                }
                catch (IOException iOException3) {
                    iOException3.printStackTrace();
                    if (n2 < 30) {
                        LogUtil.d(TAG, "EOF Exception from http connection, trying again...");
                        ++n2;
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                        }
                        var30_18 = null;
                        if (null != httpURLConnection) {
                            httpURLConnection.disconnect();
                        }
                        if (bufferedInputStream != null) {
                            try {
                                bufferedInputStream.close();
                            }
                            catch (IOException iOException2222) {
                                iOException2222.printStackTrace();
                            }
                            bufferedInputStream = null;
                        }
                        if (byteArrayOutputStream == null) continue;
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException2222) {
                            iOException2222.printStackTrace();
                        }
                        byteArrayOutputStream = null;
                        continue;
                    }
                    LogUtil.d(TAG, "EOF Exception from http connection giving up...");
                    bDSHTTPResponse.m_request_status = 2;
                    bDSHTTPResponse.m_http_status = 2000;
                    bDSHTTPResponse.m_log = "error_msg=" + iOException3.getMessage();
                    var30_18 = null;
                    if (null != httpURLConnection) {
                        httpURLConnection.disconnect();
                    }
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException2222) {
                            iOException2222.printStackTrace();
                        }
                        bufferedInputStream = null;
                    }
                    if (byteArrayOutputStream == null) break;
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException2222) {
                        iOException2222.printStackTrace();
                    }
                    byteArrayOutputStream = null;
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bDSHTTPResponse.m_http_status = 2000;
                    bDSHTTPResponse.m_request_status = 2;
                    bDSHTTPResponse.m_log = "error_msg=" + exception.getMessage();
                    var30_18 = null;
                    if (null != httpURLConnection) {
                        httpURLConnection.disconnect();
                    }
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException2222) {
                            iOException2222.printStackTrace();
                        }
                        bufferedInputStream = null;
                    }
                    if (byteArrayOutputStream == null) break;
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException2222) {
                        iOException2222.printStackTrace();
                    }
                    byteArrayOutputStream = null;
                    break;
                }
            }
            catch (Throwable throwable) {
                var30_18 = null;
                if (null != httpURLConnection) {
                    httpURLConnection.disconnect();
                }
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException2222) {
                        iOException2222.printStackTrace();
                    }
                    bufferedInputStream = null;
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException2222) {
                        iOException2222.printStackTrace();
                    }
                    byteArrayOutputStream = null;
                }
                throw throwable;
            }
            break;
        }
        return bDSHTTPResponse;
    }

    public void cancelRequest() {
        try {
            this.mAgentDownload = false;
            this.mAgentUpload = false;
            if (this.mUploadConnection != null) {
                this.mUploadConnection.disconnect();
                this.mUploadConnection = null;
            }
            if (this.mDownloadConnection != null) {
                this.mDownloadConnection.disconnect();
                this.mDownloadConnection = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.e((String)TAG, (String)"BDSHttpRequestMaker cancelRequest exception");
        }
    }

    public int setupConnection(String string, String[] stringArray, float f, int n) {
        if (Log.isLoggable((String)TAG, (int)3) || DEBUG.booleanValue()) {
            this.logI(TAG, "url = " + string);
        }
        this.mErrorArray.clear();
        try {
            mHostIp = new URL(string).getHost();
            if (Log.isLoggable((String)TAG, (int)3) || DEBUG.booleanValue()) {
                this.logD(TAG, "url: " + string + " mHostIp: " + mHostIp);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.contains("up")) {
            this.generateBackupUrls(string, 1);
            return this.setupUploadConnection(string, stringArray, f, n);
        }
        if (string.contains("down")) {
            this.generateBackupUrls(string, 2);
            return this.setupDownloadConnection(string, stringArray, f, n);
        }
        Log.e((String)TAG, (String)("Error url : " + string));
        return -1;
    }

    public int setupUploadConnection(String string, String[] stringArray, float f, int n) {
        try {
            Proxy proxy = this.setAgent();
            if (proxy != null) {
                this.mUploadConnection = (HttpURLConnection)new URL(string).openConnection(proxy);
                this.mAgentUpload = true;
            } else {
                this.mUploadConnection = (HttpURLConnection)new URL(string).openConnection();
            }
            if (this.mUploadConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)this.mUploadConnection).setHostnameVerifier(this.DO_NOT_VERIFY);
            }
            this.mUploadConnection.setConnectTimeout(3000);
            this.mUploadConnection.setReadTimeout(10000);
            this.mUploadConnection.setRequestMethod("POST");
            for (int i = 0; stringArray != null && i < stringArray.length - 1; i += 2) {
                this.mUploadConnection.setRequestProperty(stringArray[i], stringArray[i + 1]);
            }
            this.mUploadConnection.setChunkedStreamingMode(0);
            this.mUploadConnection.connect();
            this.mUploadConnctionStatus = 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (!this.mRetriedNorth) {
                this.mRetriedNorth = true;
                this.setupUploadConnection(this.mNorthUpUrl, stringArray, f, n);
            } else if (!this.mRetriedSouth) {
                this.mRetriedSouth = true;
                this.setupUploadConnection(this.mSouthUpUrl, stringArray, f, n);
            }
            BDSHTTPResponse bDSHTTPResponse = new BDSHTTPResponse();
            if (exception instanceof SocketTimeoutException) {
                bDSHTTPResponse.m_http_status = 1003;
            } else if (this.mAgentUpload) {
                bDSHTTPResponse.m_http_status = 2002;
            } else {
                bDSHTTPResponse.m_request_status = 2106;
            }
            this.mAgentUpload = false;
            bDSHTTPResponse.m_response_data = null;
            bDSHTTPResponse.m_request_status = 0;
            this.mErrorArray.add(bDSHTTPResponse);
        }
        return 0;
    }

    public int setupDownloadConnection(String string, String[] stringArray, float f, int n) {
        block10: {
            try {
                Proxy proxy = this.setAgent();
                if (proxy != null) {
                    this.mDownloadConnection = (HttpURLConnection)new URL(string).openConnection(proxy);
                    this.mAgentDownload = true;
                } else {
                    this.mDownloadConnection = (HttpURLConnection)new URL(string).openConnection();
                }
                if (this.mDownloadConnection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)this.mDownloadConnection).setHostnameVerifier(this.DO_NOT_VERIFY);
                }
                this.mDownloadConnection.setConnectTimeout(3000);
                this.mDownloadConnection.setReadTimeout(10000);
                this.mDownloadConnection.setRequestMethod("POST");
                for (int i = 0; stringArray != null && i < stringArray.length - 1; i += 2) {
                    this.mDownloadConnection.setRequestProperty(stringArray[i], stringArray[i + 1]);
                }
                this.mDownloadConnection.setChunkedStreamingMode(0);
                this.mDownloadConnection.connect();
                this.mDownloadConnectionStatus = 1;
                AudioData audioData = new AudioData(3, new byte[0], true);
                OutputStream outputStream = this.mDownloadConnection.getOutputStream();
                outputStream.write(audioData.mData);
                outputStream.flush();
                outputStream.close();
                if (!Log.isLoggable((String)TAG, (int)3) && !DEBUG.booleanValue()) break block10;
                for (int i = 0; i < audioData.mData.length; ++i) {
                    this.logI(TAG, "DownloadThread mData[" + i + "] = " + Integer.toHexString(audioData.mData[i] & 0xFF));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.mRetriedNorth) {
                    this.mRetriedNorth = true;
                    this.setupDownloadConnection(this.mNorthDownUrl, stringArray, f, n);
                } else if (!this.mRetriedSouth) {
                    this.mRetriedSouth = true;
                    this.setupDownloadConnection(this.mSouthDownUrl, stringArray, f, n);
                }
                BDSHTTPResponse bDSHTTPResponse = new BDSHTTPResponse();
                bDSHTTPResponse.m_http_status = exception instanceof SocketTimeoutException ? 1005 : (this.mAgentDownload ? 2103 : 2004);
                bDSHTTPResponse.m_response_data = null;
                bDSHTTPResponse.m_request_status = 0;
                this.mErrorArray.add(bDSHTTPResponse);
                this.mAgentDownload = false;
            }
        }
        return 0;
    }

    public int sendData(byte[] byArray, boolean bl) {
        block9: {
            if (this.mUploadConnctionStatus == 2) {
                this.logW(TAG, "Upload connection stauts has already been closed.");
                return 0;
            }
            int n = byArray[4] & 0xFF;
            if (Log.isLoggable((String)TAG, (int)3) || DEBUG.booleanValue()) {
                this.logI(TAG, "sendData  dataType : " + n + " " + this.mUploadConnection.getURL());
            }
            try {
                if (this.mUploadConnection == null) {
                    Log.e((String)TAG, (String)"Upload conncetion not exist");
                    return -1;
                }
                if (this.mUploadOutputStream == null) {
                    this.mUploadOutputStream = this.mUploadConnection.getOutputStream();
                }
                this.mUploadOutputStream.write(byArray);
                this.mUploadOutputStream.flush();
                if (!bl) break block9;
                this.mUploadOutputStream.close();
                try {
                    InputStream inputStream = this.mUploadConnection.getInputStream();
                    inputStream.close();
                }
                catch (EOFException eOFException) {
                    eOFException.printStackTrace();
                }
                this.mUploadConnection.disconnect();
            }
            catch (EOFException eOFException) {
                this.logW(TAG, "send data EOFException");
                BDSHTTPResponse bDSHTTPResponse = new BDSHTTPResponse();
                bDSHTTPResponse.m_http_status = 2100;
                bDSHTTPResponse.m_response_data = null;
                bDSHTTPResponse.m_request_status = 0;
                this.mErrorArray.add(bDSHTTPResponse);
                return -1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                BDSHTTPResponse bDSHTTPResponse = new BDSHTTPResponse();
                bDSHTTPResponse.m_http_status = this.mAgentUpload ? 2102 : 2003;
                bDSHTTPResponse.m_response_data = null;
                bDSHTTPResponse.m_request_status = 0;
                this.mErrorArray.add(bDSHTTPResponse);
                this.mAgentUpload = false;
            }
        }
        return 0;
    }

    public BDSHTTPResponse readData() {
        Object object;
        if (this.mDownloadConnectionStatus == 2) {
            this.logW(TAG, "Download connection stauts has already been closed.");
            return null;
        }
        if (this.mErrorArray.size() > 0) {
            BDSHTTPResponse bDSHTTPResponse = this.mErrorArray.get(0);
            this.mErrorArray.clear();
            return bDSHTTPResponse;
        }
        boolean bl = false;
        BDSHTTPResponse bDSHTTPResponse = null;
        try {
            if (this.mDownloadInputStream == null) {
                this.mDownloadInputStream = new DataInputStream(this.mDownloadConnection.getInputStream());
            }
            object = new byte[4];
            this.mDownloadInputStream.readFully((byte[])object, 0, 4);
            int n = object[0] & 0xFF | object[1] << 8 & 0xFF00 | object[2] << 24 >>> 8 | object[3] << 24;
            byte by = this.mDownloadInputStream.readByte();
            int n2 = by & 0xFF;
            if (243 == n2) {
                this.mUploadConnctionStatus = 2;
                this.mDownloadConnectionStatus = 2;
                bl = true;
            }
            if (Log.isLoggable((String)TAG, (int)3) || DEBUG.booleanValue()) {
                this.logI(TAG, "readData dataType : " + n2 + " " + this.mDownloadConnection.getURL());
            }
            if (n > 1) {
                if (n > 67584) {
                    BDSHTTPResponse bDSHTTPResponse2 = new BDSHTTPResponse();
                    bDSHTTPResponse2.m_http_status = 2006;
                    bDSHTTPResponse2.m_response_data = null;
                    bDSHTTPResponse2.m_request_status = 0;
                    this.mErrorArray.add(bDSHTTPResponse2);
                    return bDSHTTPResponse2;
                }
                byte[] byArray = new byte[n - 1];
                for (int i = 0; i < n - 1; i += this.mDownloadInputStream.read(byArray, i, n - 1 - i)) {
                }
                String string = new String(byArray);
                if (Log.isLoggable((String)TAG, (int)3) || DEBUG.booleanValue()) {
                    this.logI(TAG, "response : " + string + " " + this.mDownloadConnection.getURL());
                }
                byte[] byArray2 = new byte[n + 4];
                System.arraycopy(object, 0, byArray2, 0, 4);
                byArray2[4] = by;
                if (n - 1 > 0) {
                    System.arraycopy(byArray, 0, byArray2, 5, n - 1);
                }
                bDSHTTPResponse = new BDSHTTPResponse();
                bDSHTTPResponse.m_http_status = 200;
                bDSHTTPResponse.m_response_data = byArray2;
                bDSHTTPResponse.m_request_status = 0;
            } else {
                byte[] byArray = new byte[5];
                System.arraycopy(object, 0, byArray, 0, 4);
                byArray[4] = by;
                bDSHTTPResponse = new BDSHTTPResponse();
                bDSHTTPResponse.m_http_status = 200;
                bDSHTTPResponse.m_response_data = byArray;
                bDSHTTPResponse.m_request_status = 0;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            BDSHTTPResponse bDSHTTPResponse3 = new BDSHTTPResponse();
            bDSHTTPResponse3.m_http_status = this.mAgentDownload ? 2104 : 2005;
            bDSHTTPResponse3.m_response_data = null;
            bDSHTTPResponse3.m_request_status = 0;
            this.mAgentDownload = false;
            this.mErrorArray.add(bDSHTTPResponse3);
        }
        catch (SSLException sSLException) {
            BDSHTTPResponse bDSHTTPResponse4 = new BDSHTTPResponse();
            this.logI(TAG, "SSLException");
            bDSHTTPResponse4.m_http_status = 2100;
            bDSHTTPResponse4.m_response_data = null;
            bDSHTTPResponse4.m_request_status = 0;
            this.mErrorArray.add(bDSHTTPResponse4);
        }
        catch (Exception exception) {
            this.logI(TAG, "Exception");
            exception.printStackTrace();
            BDSHTTPResponse bDSHTTPResponse5 = new BDSHTTPResponse();
            bDSHTTPResponse5.m_http_status = 2100;
            bDSHTTPResponse5.m_response_data = null;
            bDSHTTPResponse5.m_request_status = 0;
            this.mErrorArray.add(bDSHTTPResponse5);
        }
        if (this.mErrorArray.size() > 0) {
            object = this.mErrorArray.get(0);
            this.mErrorArray.clear();
            return object;
        }
        return bDSHTTPResponse;
    }

    private static String convertHostname(String string) {
        if (string.equals("vse.baidu.com") || string.equals("vop.baidu.com") || string.equals("openapi.baidu.com") || string.equals("upl.baidu.com")) {
            return string;
        }
        if (string.equals(mHostIp)) {
            return CommonParam.REQUEST_URL;
        }
        return string;
    }

    private Proxy setAgent() {
        String string = CommonParam.AGENT_URL;
        if (string != "") {
            try {
                URL uRL = new URL(string);
                String string2 = InetAddress.getByName(uRL.getHost()).getHostAddress();
                Log.e((String)TAG, (String)("ip: " + string2 + " port: " + uRL.getPort()));
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(uRL.getHost(), uRL.getPort()));
                return proxy;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    private void generateBackupUrls(String string, int n) {
        if (1 == n) {
            this.mNorthUpUrl = string.replace(mHostIp, BACKUP_URL_NORTH);
            this.mSouthUpUrl = string.replace(mHostIp, BACKUP_URL_SOUTH);
        } else if (2 == n) {
            this.mNorthDownUrl = string.replace(mHostIp, BACKUP_URL_NORTH);
            this.mSouthDownUrl = string.replace(mHostIp, BACKUP_URL_SOUTH);
        }
    }

    void logD(String string, String string2) {
        Log.d((String)string, (String)(string2 + " &" + Integer.toHexString(this.hashCode()) + ", "));
    }

    void logW(String string, String string2) {
        Log.w((String)string, (String)(string2 + " &" + Integer.toHexString(this.hashCode()) + ", "));
    }

    void logI(String string, String string2) {
        Log.i((String)string, (String)(string2 + " &" + Integer.toHexString(this.hashCode()) + ", "));
    }

    private class AudioData {
        public int mType;
        public byte[] mData;
        public boolean mIsLast;

        public AudioData(int n, byte[] byArray, boolean bl) {
            this.mType = n;
            this.mIsLast = bl;
            int n2 = byArray.length + 1;
            byte[] byArray2 = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24)};
            byte[] byArray3 = new byte[]{(byte)n};
            this.mData = new byte[n2 + 4];
            System.arraycopy(byArray2, 0, this.mData, 0, 4);
            System.arraycopy(byArray3, 0, this.mData, 4, 1);
            System.arraycopy(byArray, 0, this.mData, 5, byArray.length);
            if (Log.isLoggable((String)BDSHttpRequestMaker.TAG, (int)3) || DEBUG.booleanValue()) {
                BDSHttpRequestMaker.this.logI(BDSHttpRequestMaker.TAG, "AudioData : mType = " + this.mType + " | mIsLast = " + this.mIsLast + " | mData = " + this.mData.length);
            }
        }
    }

    private class MyDownloadThread
    extends Thread {
        private MyDownloadThread() {
        }

        public void run() {
        }
    }

    private class MyUploadThread
    extends Thread {
        private MyUploadThread() {
        }

        public void run() {
        }
    }
}

