/*
 * Decompiled with CFR 0.152.
 */
package com.mob.wrappers;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import com.mob.pushsdk.MobPush;
import com.mob.pushsdk.MobPushCallback;
import com.mob.pushsdk.MobPushCustomMessage;
import com.mob.pushsdk.MobPushCustomNotification;
import com.mob.pushsdk.MobPushLocalNotification;
import com.mob.pushsdk.MobPushNotifyMessage;
import com.mob.pushsdk.MobPushReceiver;
import com.mob.tools.proguard.ClassKeeper;
import com.mob.tools.proguard.PublicMemberKeeper;
import com.mob.tools.utils.UIHandler;
import com.mob.wrappers.SDKWrapper;
import java.io.Serializable;
import java.util.HashMap;

public class MobPushWrapper
extends SDKWrapper
implements PublicMemberKeeper {
    private static int state;
    private static HashMap<MobPushReceiverWrapper, Object> receiverWrapperMap;

    private static synchronized boolean isAvailable() {
        if (state == 0) {
            state = MobPushWrapper.isAvailable("MOBPUSH");
        }
        return state == 1;
    }

    public static void getRegistrationId(final MobPushCallbackWrapper<String> callback) {
        if (MobPushWrapper.isAvailable()) {
            try {
                MobPush.getRegistrationId((MobPushCallback)new MobPushCallback<String>(){

                    public void onCallback(String s) {
                        if (callback != null) {
                            callback.onSuccess(s);
                        }
                    }
                });
            }
            catch (Throwable t) {
                if (callback != null) {
                    UIHandler.sendEmptyMessage((int)0, (Handler.Callback)new Handler.Callback(){

                        public boolean handleMessage(Message msg) {
                            callback.onSuccess(null);
                            return false;
                        }
                    });
                }
            }
        } else if (callback != null) {
            UIHandler.sendEmptyMessage((int)0, (Handler.Callback)new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    callback.onSuccess(null);
                    return false;
                }
            });
        }
    }

    public static void addPushReceiver(final MobPushReceiverWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        if (MobPushWrapper.isAvailable()) {
            try {
                MobPushReceiver obj = null;
                if (receiverWrapperMap == null) {
                    receiverWrapperMap = new HashMap();
                } else {
                    obj = (MobPushReceiver)receiverWrapperMap.get(wrapper);
                }
                if (obj == null) {
                    obj = new MobPushReceiver(){

                        public void onCustomMessageReceive(Context context, MobPushCustomMessage message) {
                            MobPushCustomMessageWrapper obj = null;
                            if (message != null) {
                                obj = new MobPushCustomMessageWrapper(message.getContent(), message.getExtrasMap(), message.getMessageId(), message.getTimestamp());
                            }
                            wrapper.onCustomMessageReceive(context, obj);
                        }

                        public void onNotifyMessageReceive(Context context, MobPushNotifyMessage message) {
                            MobPushNotifyMessageWrapper obj = null;
                            if (message != null) {
                                obj = new MobPushNotifyMessageWrapper(message.getStyle(), message.getTitle(), message.getContent(), message.getStyleContent(), message.getInboxStyleContent(), message.getExtrasMap(), message.getMessageId(), message.getTimestamp(), message.isVoice(), message.isShake(), message.isLight());
                            }
                            wrapper.onNotifyMessageReceive(context, obj);
                        }

                        public void onNotifyMessageOpenedReceive(Context context, MobPushNotifyMessage message) {
                            MobPushNotifyMessageWrapper obj = null;
                            if (message != null) {
                                obj = new MobPushNotifyMessageWrapper(message.getStyle(), message.getTitle(), message.getContent(), message.getStyleContent(), message.getInboxStyleContent(), message.getExtrasMap(), message.getMessageId(), message.getTimestamp(), message.isVoice(), message.isShake(), message.isLight());
                            }
                            wrapper.onNotifyMessageOpenedReceive(context, obj);
                        }

                        public void onTagsCallback(Context context, String[] tags, int operation, int errorCode) {
                            wrapper.onTagsCallback(context, tags, operation, errorCode);
                        }

                        public void onAliasCallback(Context context, String alias, int operation, int errorCode) {
                            wrapper.onAliasCallback(context, alias, operation, errorCode);
                        }
                    };
                    receiverWrapperMap.put(wrapper, obj);
                    MobPush.addPushReceiver((MobPushReceiver)obj);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void removePushReceiver(MobPushReceiverWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        if (MobPushWrapper.isAvailable()) {
            try {
                Object obj;
                if (receiverWrapperMap != null && (obj = receiverWrapperMap.get(wrapper)) != null) {
                    MobPush.removePushReceiver((MobPushReceiver)((MobPushReceiver)obj));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void stopPush() {
        if (MobPushWrapper.isAvailable()) {
            try {
                MobPush.stopPush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void restartPush() {
        if (MobPushWrapper.isAvailable()) {
            try {
                MobPush.restartPush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean isPushStopped() {
        if (MobPushWrapper.isAvailable()) {
            try {
                return MobPush.isPushStopped();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static void setAlias(String alias) {
        if (MobPushWrapper.isAvailable()) {
            try {
                MobPush.setAlias((String)alias);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void getAlias() {
        if (MobPushWrapper.isAvailable()) {
            try {
                MobPush.getAlias();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void deleteAlias() {
        if (MobPushWrapper.isAvailable()) {
            try {
                MobPush.deleteAlias();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void addTags(String[] tags) {
        if (MobPushWrapper.isAvailable()) {
            try {
                MobPush.addTags((String[])tags);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void getTags() {
        if (MobPushWrapper.isAvailable()) {
            try {
                MobPush.getTags();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void deleteTags(String[] tags) {
        if (MobPushWrapper.isAvailable()) {
            try {
                MobPush.deleteTags((String[])tags);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void cleanTags() {
        if (MobPushWrapper.isAvailable()) {
            try {
                MobPush.cleanTags();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setSilenceTime(int startHour, int startMinute, int endHour, int endMinute) {
        if (MobPushWrapper.isAvailable()) {
            try {
                MobPush.setSilenceTime((int)startHour, (int)startMinute, (int)endHour, (int)endMinute);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setCustomNotification(final MobPushCustomNotificationWrapper wrapper) {
        if (MobPushWrapper.isAvailable()) {
            try {
                if (wrapper == null) {
                    MobPush.setCustomNotification(null);
                } else {
                    MobPush.setCustomNotification((MobPushCustomNotification)new MobPushCustomNotification(){

                        public Notification getNotification(Context context, NotificationManager notificationManager, long when, String tickerText, String title, String content, int flag, int style, String styleContent, String[] inboxStyleContent, boolean voice, boolean shake, boolean light) {
                            try {
                                return wrapper.getNotification(context, notificationManager, when, tickerText, title, content, flag, style, styleContent, inboxStyleContent, voice, shake, light);
                            }
                            catch (Throwable t) {
                                return new Notification();
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean addLocalNotification(MobPushLocalNotificationWrapper notification) {
        if (MobPushWrapper.isAvailable()) {
            if (notification == null) {
                return false;
            }
            MobPushLocalNotification obj = new MobPushLocalNotification(notification.getStyle(), notification.getTitle(), notification.getContent(), notification.getStyleContent(), notification.getInboxStyleContent(), notification.getExtrasMap(), notification.getMessageId(), notification.getTimestamp(), notification.isVoice(), notification.isShake(), notification.isLight());
            obj.setNotificationId(notification.getNotificationId());
            return MobPush.addLocalNotification((MobPushLocalNotification)obj);
        }
        return false;
    }

    public static boolean removeLocalNotification(int notificationId) {
        if (MobPushWrapper.isAvailable()) {
            return MobPush.removeLocalNotification((int)notificationId);
        }
        return false;
    }

    public static boolean clearLocalNotifications() {
        if (MobPushWrapper.isAvailable()) {
            return MobPush.clearLocalNotifications();
        }
        return false;
    }

    static {
        receiverWrapperMap = null;
    }

    public static interface MobPushReceiverWrapper {
        public void onCustomMessageReceive(Context var1, MobPushCustomMessageWrapper var2);

        public void onNotifyMessageReceive(Context var1, MobPushNotifyMessageWrapper var2);

        public void onNotifyMessageOpenedReceive(Context var1, MobPushNotifyMessageWrapper var2);

        public void onTagsCallback(Context var1, String[] var2, int var3, int var4);

        public void onAliasCallback(Context var1, String var2, int var3, int var4);
    }

    public static interface MobPushCallbackWrapper<T> {
        public void onSuccess(T var1);
    }

    public static interface MobPushCustomNotificationWrapper {
        public Notification getNotification(Context var1, NotificationManager var2, long var3, String var5, String var6, String var7, int var8, int var9, String var10, String[] var11, boolean var12, boolean var13, boolean var14);
    }

    class MobPushLocalNotificationWrapper
    extends MobPushNotifyMessageWrapper {
        private int notificationId;

        public MobPushLocalNotificationWrapper() {
        }

        public MobPushLocalNotificationWrapper(int style, String title, String content, String styleContent, String[] inboxStyleContent, HashMap<String, String> extrasMap, String messageId, long timestamp, boolean voice, boolean shake, boolean light) {
            super(style, title, content, styleContent, inboxStyleContent, extrasMap, messageId, timestamp, voice, shake, light);
        }

        public void setNotificationId(int notificationId) {
            this.notificationId = notificationId;
        }

        public int getNotificationId() {
            return this.notificationId;
        }
    }

    public static class MobPushNotifyMessageWrapper
    implements ClassKeeper,
    Serializable {
        private int style;
        private String title;
        private String content;
        private String styleContent;
        private String[] inboxStyleContent;
        private HashMap<String, String> extrasMap;
        private String messageId;
        private long timestamp;
        private boolean voice = true;
        private boolean shake = true;
        private boolean light = true;

        public MobPushNotifyMessageWrapper() {
        }

        public MobPushNotifyMessageWrapper(int style, String title, String content, String styleContent, String[] inboxStyleContent, HashMap<String, String> extrasMap, String messageId, long timestamp, boolean voice, boolean shake, boolean light) {
            this.style = style;
            this.title = title;
            this.content = content;
            this.styleContent = styleContent;
            this.inboxStyleContent = inboxStyleContent;
            this.extrasMap = extrasMap;
            this.messageId = messageId;
            this.timestamp = timestamp;
            this.voice = voice;
            this.shake = shake;
            this.light = light;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public void setVoice(boolean enable) {
            this.voice = enable;
        }

        public void setLight(boolean enable) {
            this.light = enable;
        }

        public void setShake(boolean enable) {
            this.shake = enable;
        }

        public void setStyle(int style) {
            this.style = style;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setStyleContent(String styleContent) {
            this.styleContent = styleContent;
        }

        public void setInboxStyleContent(String[] inboxStyleContent) {
            this.inboxStyleContent = inboxStyleContent;
        }

        public void setExtrasMap(HashMap<String, String> extrasMap) {
            this.extrasMap = extrasMap;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public int getStyle() {
            return this.style;
        }

        public boolean isVoice() {
            return this.voice;
        }

        public boolean isShake() {
            return this.shake;
        }

        public boolean isLight() {
            return this.light;
        }

        public String getTitle() {
            return this.title;
        }

        public String getContent() {
            return this.content;
        }

        public HashMap<String, String> getExtrasMap() {
            return this.extrasMap;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getStyleContent() {
            return this.styleContent;
        }

        public String[] getInboxStyleContent() {
            return this.inboxStyleContent;
        }
    }

    public static class MobPushCustomMessageWrapper
    implements ClassKeeper,
    Serializable {
        private String content;
        private HashMap<String, String> extrasMap;
        private String messageId;
        private long timestamp;

        public MobPushCustomMessageWrapper(String content, HashMap<String, String> extrasMap, String messageId, long timestamp) {
            this.content = content;
            this.extrasMap = extrasMap;
            this.messageId = messageId;
            this.timestamp = timestamp;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setExtrasMap(HashMap<String, String> extrasMap) {
            this.extrasMap = extrasMap;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String getContent() {
            return this.content;
        }

        public HashMap<String, String> getExtrasMap() {
            return this.extrasMap;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

