/*
 * Decompiled with CFR 0.152.
 */
package com.mob.wrappers;

import com.mob.paysdk.AliPayAPI;
import com.mob.paysdk.MobPayAPI;
import com.mob.paysdk.OnPayListener;
import com.mob.paysdk.PayResult;
import com.mob.paysdk.PaySDK;
import com.mob.paysdk.WXPayAPI;
import com.mob.tools.proguard.PublicMemberKeeper;
import com.mob.wrappers.SDKWrapper;

public class PaySDKWrapper
extends SDKWrapper
implements PublicMemberKeeper {
    private static int state;

    private static synchronized boolean isAvailable() {
        if (state == 0) {
            state = PaySDKWrapper.isAvailable("PAYSDK");
        }
        return state == 1;
    }

    public static int pay(final Order order, final int platform, final PayCallback callback) throws LinkagePaySDKError, UnknowOrder, UnsupportedPayPlatform {
        Class<AliPayAPI> apiClazz;
        com.mob.paysdk.PayOrder innerOrder;
        if (!PaySDKWrapper.isAvailable()) {
            throw new LinkagePaySDKError();
        }
        if (order instanceof PayOrder) {
            innerOrder = ((PayOrder)order).order;
        } else if (order instanceof TicketOrder) {
            innerOrder = ((TicketOrder)order).order;
        } else {
            throw new UnknowOrder();
        }
        if (50 == platform) {
            apiClazz = AliPayAPI.class;
        } else if (22 == platform) {
            apiClazz = WXPayAPI.class;
        } else {
            throw new UnsupportedPayPlatform();
        }
        MobPayAPI payAPI = PaySDK.createMobPayAPI(apiClazz);
        payAPI.pay((com.mob.paysdk.Order)innerOrder, new OnPayListener(){

            public boolean onWillPay(String s, Object o, MobPayAPI mobPayAPI) {
                return callback.onWillPay(order, platform, s);
            }

            public void onPayEnd(PayResult payResult, Object o, MobPayAPI mobPayAPI) {
                if (null != callback) {
                    callback.onPayEnd(order, platform, payResult.ordinal());
                }
            }
        });
        return 0;
    }

    public static class TicketOrder
    extends Order
    implements PublicMemberKeeper {
        private com.mob.paysdk.TicketOrder order;

        public TicketOrder() {
            if (PaySDKWrapper.isAvailable()) {
                this.order = new com.mob.paysdk.TicketOrder();
            }
        }

        public void setTicketId(String tId) {
            if (PaySDKWrapper.isAvailable()) {
                this.order.setTicketId(tId);
            }
        }

        public String getTicketId() {
            if (PaySDKWrapper.isAvailable()) {
                return this.order.getTicketId();
            }
            return "";
        }
    }

    public static class PayOrder
    extends Order
    implements PublicMemberKeeper {
        private com.mob.paysdk.PayOrder order;

        public PayOrder() {
            if (PaySDKWrapper.isAvailable()) {
                this.order = new com.mob.paysdk.PayOrder();
            }
        }

        public String getOrderNo() {
            if (PaySDKWrapper.isAvailable()) {
                return this.order.getOrderNo();
            }
            return "";
        }

        public void setOrderNo(String orderNo) {
            if (PaySDKWrapper.isAvailable()) {
                this.order.setOrderNo(orderNo);
            }
        }

        public int getAmount() {
            if (PaySDKWrapper.isAvailable()) {
                return this.order.getAmount();
            }
            return 0;
        }

        public void setAmount(int amount) {
            if (PaySDKWrapper.isAvailable()) {
                this.order.setAmount(amount);
            }
        }

        public String getSubject() {
            if (PaySDKWrapper.isAvailable()) {
                return this.order.getSubject();
            }
            return "";
        }

        public void setSubject(String subject) {
            if (PaySDKWrapper.isAvailable()) {
                this.order.setSubject(subject);
            }
        }

        public String getBody() {
            if (PaySDKWrapper.isAvailable()) {
                return this.order.getBody();
            }
            return "";
        }

        public void setBody(String body) {
            if (PaySDKWrapper.isAvailable()) {
                this.order.setBody(body);
            }
        }

        public String getDescription() {
            if (PaySDKWrapper.isAvailable()) {
                return this.order.getDescription();
            }
            return "";
        }

        public void setDescription(String description) {
            if (PaySDKWrapper.isAvailable()) {
                this.order.setDescription(description);
            }
        }

        public String getMetadata() {
            if (PaySDKWrapper.isAvailable()) {
                return this.order.getMetadata();
            }
            return "";
        }

        public void setMetadata(String metadata) {
            if (PaySDKWrapper.isAvailable()) {
                this.order.setMetadata(metadata);
            }
        }

        public String getTicketId() {
            if (PaySDKWrapper.isAvailable()) {
                return this.order.getTicketId();
            }
            return "";
        }
    }

    public static abstract class Order {
    }

    public static interface PayCallback {
        public boolean onWillPay(Order var1, int var2, String var3);

        public void onPayEnd(Order var1, int var2, int var3);
    }

    public static class UnsupportedPayPlatform
    extends Exception {
    }

    public static class UnknowOrder
    extends Exception {
    }

    public static class LinkagePaySDKError
    extends Error {
    }
}

