/*
 * Decompiled with CFR 0.152.
 */
package com.mob.wrappers;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.mob.tools.proguard.PublicMemberKeeper;
import com.mob.tools.utils.UIHandler;
import com.mob.ums.OperationCallback;
import com.mob.ums.UMSSDK;
import com.mob.ums.gui.UMSGUI;
import com.mob.wrappers.SDKWrapper;

public class UMSSDKWrapper
extends SDKWrapper
implements PublicMemberKeeper {
    private static int state;
    private static int stateGUI;

    private static synchronized boolean isAvailable() {
        if (state == 0) {
            state = UMSSDKWrapper.isAvailable("UMSSDK");
        }
        return state == 1;
    }

    public static String getLoginUserToken() {
        if (UMSSDKWrapper.isAvailable()) {
            return UMSSDK.getLoginUserToken();
        }
        return null;
    }

    public static String getLoginUserId() {
        if (UMSSDKWrapper.isAvailable()) {
            return UMSSDK.getLoginUserId();
        }
        return null;
    }

    public static boolean hasLogin() {
        return !TextUtils.isEmpty((CharSequence)UMSSDKWrapper.getLoginUserToken());
    }

    public static void logout() {
        if (UMSSDKWrapper.isAvailable()) {
            UMSSDK.logout(null);
        }
    }

    public static void getLoginUser(final CallbackWrapper callback) {
        if (UMSSDKWrapper.isAvailable()) {
            try {
                UMSSDK.getLoginUser((OperationCallback)new OperationCallback<com.mob.ums.User>(){

                    public void onSuccess(com.mob.ums.User user) {
                        if (callback != null) {
                            callback.onSuccess(new User(user));
                        }
                    }

                    public void onFailed(Throwable throwable) {
                        if (callback != null) {
                            callback.onError(throwable);
                        }
                    }
                });
            }
            catch (Throwable t) {
                UIHandler.sendEmptyMessage((int)0, (Handler.Callback)new Handler.Callback(){

                    public boolean handleMessage(Message msg) {
                        if (callback != null) {
                            callback.onError(t);
                        }
                        return false;
                    }
                });
            }
        } else {
            UMSSDKWrapper.unAvailable(callback, 1);
        }
    }

    private static boolean isAvailableGUI() {
        if (stateGUI == 0) {
            stateGUI = -1;
            try {
                UMSGUI gui = new UMSGUI();
                if (gui != null) {
                    stateGUI = 1;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return stateGUI == 1;
    }

    public static void showLogin(final CallbackWrapper callback) {
        if (UMSSDKWrapper.isAvailableGUI()) {
            UMSGUI.showLogin((OperationCallback)new OperationCallback<com.mob.ums.User>(){

                public void onSuccess(com.mob.ums.User user) {
                    if (callback != null) {
                        callback.onSuccess(new User(user));
                    }
                }

                public void onFailed(Throwable throwable) {
                    if (callback != null) {
                        callback.onError(throwable);
                    }
                }
            });
        } else {
            UMSSDKWrapper.unAvailable(callback, 2);
        }
    }

    private static void unAvailable(final CallbackWrapper callback, final int type) {
        UIHandler.sendEmptyMessage((int)0, (Handler.Callback)new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                if (callback != null) {
                    Throwable t = null;
                    t = type == 2 ? new Throwable("UMSSDKGUI is not available") : new Throwable("UMSSDK is not available");
                    callback.onError(t);
                }
                return false;
            }
        });
    }

    public static interface CallbackWrapper {
        public void onSuccess(User var1);

        public void onError(Throwable var1);
    }

    public static class User
    implements PublicMemberKeeper {
        private com.mob.ums.User user;

        private User(com.mob.ums.User user) {
            this.user = user;
        }

        public String getUserId() {
            return this.user == null ? null : (String)this.user.id.get();
        }

        public String getNickname() {
            return this.user == null ? null : (String)this.user.nickname.get();
        }

        public String getAvatar() {
            return this.user == null ? null : (this.user.avatar.isNull() ? null : ((String[])this.user.avatar.get())[0]);
        }
    }
}

