/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mapsdk.raster.model;

import android.graphics.DashPathEffect;
import android.os.Bundle;
import android.os.Parcel;
import com.tencent.mapsdk.raster.model.LatLng;

public final class CircleOptions {
    private int strokeColor = -16777216;
    private float strokeWidth = 10.0f;
    private boolean isVisible = true;
    private double radius = 0.0;
    private float zIndex = 0.0f;
    private LatLng point = null;
    private int fillColor = 0;
    private boolean strokeDash = false;
    private DashPathEffect dashPathEffect = null;
    private String id;

    public final void writeToParcel(Parcel parcel, int n) {
        Bundle bundle = new Bundle();
        if (this.point != null) {
            bundle.putDouble("lat", this.point.getLatitude());
            bundle.putDouble("lng", this.point.getLongitude());
        }
        parcel.writeBundle(bundle);
        parcel.writeDouble(this.radius);
        parcel.writeFloat(this.strokeWidth);
        parcel.writeInt(this.strokeColor);
        parcel.writeInt(this.fillColor);
        parcel.writeFloat(this.zIndex);
        parcel.writeByte((byte)(this.isVisible ? 1 : 0));
        parcel.writeString(this.id);
    }

    public final int describeContents() {
        return 0;
    }

    public final CircleOptions center(LatLng latLng) {
        this.point = latLng;
        return this;
    }

    public final CircleOptions radius(double d2) {
        this.radius = d2;
        return this;
    }

    public final CircleOptions strokeWidth(float f2) {
        this.strokeWidth = f2;
        return this;
    }

    public final CircleOptions strokeColor(int n) {
        this.strokeColor = n;
        return this;
    }

    public final CircleOptions fillColor(int n) {
        this.fillColor = n;
        return this;
    }

    public final CircleOptions zIndex(float f2) {
        this.zIndex = f2;
        return this;
    }

    public final CircleOptions visible(boolean bl) {
        this.isVisible = bl;
        return this;
    }

    public final CircleOptions strokeDash(boolean bl) {
        this.strokeDash = bl;
        return this;
    }

    public final CircleOptions strokeDashPathEffect(DashPathEffect dashPathEffect) {
        this.dashPathEffect = dashPathEffect;
        return this;
    }

    public final LatLng getCenter() {
        return this.point;
    }

    public final double getRadius() {
        return this.radius;
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public final int getStrokeColor() {
        return this.strokeColor;
    }

    public final int getFillColor() {
        return this.fillColor;
    }

    public final float getZIndex() {
        return this.zIndex;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final boolean getStrokeDash() {
        return this.strokeDash;
    }

    public final DashPathEffect getStrokeDashPathEffect() {
        return this.dashPathEffect;
    }
}

