/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mapsdk.raster.model;

import com.tencent.mapsdk.raster.model.BitmapDescriptor;
import com.tencent.mapsdk.raster.model.LatLng;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolylineOptions {
    private boolean isDottedLine = false;
    private boolean isGeodesic = false;
    private final List<LatLng> points = new ArrayList<LatLng>();
    private boolean isVisible = true;
    private int color = -16777216;
    private float width = 10.0f;
    private float zIndex = 0.0f;
    private BitmapDescriptor arrowTexture;
    private float edgeWidth = 0.0f;
    private int edgeColor = -983041;
    private float arrowGap = 90.0f;

    public final PolylineOptions arrowGap(float f2) {
        if (f2 > 0.0f) {
            this.arrowGap = f2;
        }
        return this;
    }

    public final PolylineOptions arrowTexture(BitmapDescriptor bitmapDescriptor) {
        if (bitmapDescriptor != null) {
            this.arrowTexture = bitmapDescriptor;
        }
        return this;
    }

    public final BitmapDescriptor getArrowTexture() {
        return this.arrowTexture;
    }

    public final PolylineOptions edgeWidth(float f2) {
        if (f2 > 0.0f) {
            this.edgeWidth = f2;
        }
        return this;
    }

    public final float getEdgeWidth() {
        return this.edgeWidth;
    }

    public final PolylineOptions edgeColor(int n) {
        this.edgeColor = n;
        return this;
    }

    public final int getEdgeColor() {
        return this.edgeColor;
    }

    public final float getArrowGap() {
        return this.arrowGap;
    }

    public final PolylineOptions add(LatLng latLng) {
        this.points.add(latLng);
        return this;
    }

    public final PolylineOptions add(LatLng ... latLngArray) {
        this.points.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolylineOptions addAll(Iterable<LatLng> object) {
        object = object.iterator();
        while (object.hasNext()) {
            LatLng latLng = (LatLng)object.next();
            this.points.add(latLng);
        }
        return this;
    }

    public final PolylineOptions width(float f2) {
        this.width = f2;
        return this;
    }

    public final PolylineOptions color(int n) {
        this.color = n;
        return this;
    }

    public final PolylineOptions zIndex(float f2) {
        this.zIndex = f2;
        return this;
    }

    public final PolylineOptions visible(boolean bl) {
        this.isVisible = bl;
        return this;
    }

    public final PolylineOptions geodesic(boolean bl) {
        this.isGeodesic = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.points;
    }

    public final float getWidth() {
        return this.width;
    }

    public final int getColor() {
        return this.color;
    }

    public final float getZIndex() {
        return this.zIndex;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final PolylineOptions setDottedLine(boolean bl) {
        this.isDottedLine = bl;
        return this;
    }

    public final boolean isDottedLine() {
        return this.isDottedLine;
    }

    public final boolean isGeodesic() {
        return this.isGeodesic;
    }
}

