/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import com.tencent.mapsdk.raster.model.GeoPoint;
import com.tencent.mapsdk.rastercore.f.a;
import com.tencent.tencentmap.mapsdk.map.MapView;
import com.tencent.tencentmap.mapsdk.map.Overlay;
import com.tencent.tencentmap.mapsdk.map.OverlayItem;
import com.tencent.tencentmap.mapsdk.map.Projection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

@Deprecated
public abstract class ItemizedOverlay<Item extends OverlayItem>
extends Overlay {
    private boolean mDrawFocusedItem = true;
    private Drawable defaultItemMarker;
    private ItemsContainer mContainer = null;
    private OnFocusChangeListener mlistener = null;
    private int mLastFocus = -1;
    private int mCurFocus = -1;
    private Item itemSelected;
    private boolean boLongPress = false;
    private boolean boDrawShadow = true;

    public ItemizedOverlay(Drawable drawable) {
        this.defaultItemMarker = drawable;
        if (this.defaultItemMarker == null) {
            throw new IllegalArgumentException("the drawable can not be null!");
        }
        drawable = this.defaultItemMarker.getBounds();
        if (drawable == null) {
            ItemizedOverlay.boundCenterBottom(this.defaultItemMarker);
            return;
        }
        if (drawable.left == 0 && drawable.right == 0 && drawable.top == 0 && drawable.bottom == 0) {
            ItemizedOverlay.boundCenterBottom(this.defaultItemMarker);
        }
    }

    public ItemizedOverlay(Context context) {
        String string = "marker.png";
        string = a.a("marker.png");
        this.defaultItemMarker = new BitmapDrawable(context.getResources(), (Bitmap)string);
        ItemizedOverlay.boundCenterBottom(this.defaultItemMarker);
    }

    public static Drawable boundCenterBottom(Drawable drawable) {
        return ItemizedOverlay.resetBound(drawable, BoundPos.CenterBottom);
    }

    public static Drawable boundCenter(Drawable drawable) {
        return ItemizedOverlay.resetBound(drawable, BoundPos.Center);
    }

    private static Drawable resetBound(Drawable drawable, BoundPos boundPos) {
        if (drawable == null || BoundPos.Normal == boundPos) {
            return null;
        }
        drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        Rect rect = drawable.getBounds();
        int n = rect.width() / 2;
        int n2 = -rect.height();
        int n3 = 0;
        if (boundPos == BoundPos.Center) {
            n3 = -(n2 /= 2);
        }
        drawable.setBounds(-n, n2, n, n3);
        return drawable;
    }

    protected abstract Item createItem(int var1);

    public abstract int size();

    protected final void populate() {
        if (this.mContainer != null) {
            this.mContainer.release();
        }
        this.mContainer = new ItemsContainer();
        this.mLastFocus = -1;
        this.mCurFocus = -1;
    }

    public void setShadowEnable(boolean bl) {
        this.boDrawShadow = bl;
    }

    public boolean isShadowEnable() {
        return this.boDrawShadow;
    }

    public GeoPoint getCenter() {
        if (this.mContainer == null) {
            return null;
        }
        return new GeoPoint(this.mContainer.iLatitudeCenter, this.mContainer.iLongitudeCenter);
    }

    protected int getIndexToDraw(int n) {
        if (this.mContainer == null) {
            return -1;
        }
        return this.mContainer.getPosByRank(n);
    }

    public final Item getItem(int n) {
        if (this.mContainer == null) {
            return null;
        }
        return this.mContainer.getItemByPos(n);
    }

    public int getLatSpanE6() {
        if (this.mContainer == null) {
            return 0;
        }
        return this.mContainer.getSpan(true);
    }

    public int getLonSpanE6() {
        if (this.mContainer == null) {
            return 0;
        }
        return this.mContainer.getSpan(false);
    }

    public void setOnFocusChangeListener(OnFocusChangeListener onFocusChangeListener) {
        this.mlistener = onFocusChangeListener;
    }

    public void setDrawFocusedItem(boolean bl) {
        this.mDrawFocusedItem = bl;
    }

    public final int getLastFocusedIndex() {
        return this.mLastFocus;
    }

    protected void setLastFocusedIndex(int n) {
        this.mLastFocus = n;
    }

    public Item getFocus() {
        if (this.mContainer == null) {
            return null;
        }
        Item Item = null;
        if (this.mCurFocus != -1) {
            Item = this.mContainer.getItemByPos(this.mCurFocus);
        }
        return Item;
    }

    public void setFocus(Item Item) {
        if (this.mContainer == null) {
            return;
        }
        if (Item != null && this.mCurFocus == this.mContainer.getIndexByItem(Item)) {
            return;
        }
        if (Item == null && this.mCurFocus != -1) {
            if (this.mlistener != null) {
                this.mlistener.onFocusChanged(this, (OverlayItem)Item);
            }
            this.mCurFocus = -1;
            return;
        }
        this.mCurFocus = this.mContainer.getIndexByItem(Item);
        if (this.mCurFocus != -1) {
            this.setLastFocusedIndex(this.mCurFocus);
            if (this.mlistener != null) {
                this.mlistener.onFocusChanged(this, (OverlayItem)Item);
            }
        }
    }

    public Item nextFocus(boolean bl) {
        int n;
        if (this.mContainer == null || this.mContainer.count() == 0) {
            return null;
        }
        if (this.mLastFocus == -1) {
            if (this.mCurFocus == -1) {
                return null;
            }
            return this.mContainer.getItemByPos(0);
        }
        int n2 = n = this.mCurFocus == -1 ? this.mLastFocus : this.mCurFocus;
        if (bl) {
            return this.forwordFocus(n);
        }
        return this.backwordFocus(n);
    }

    private Item backwordFocus(int n) {
        if (this.mContainer == null) {
            return null;
        }
        if (n == 0) {
            return null;
        }
        return this.mContainer.getItemByPos(n - 1);
    }

    private Item forwordFocus(int n) {
        if (this.mContainer == null) {
            return null;
        }
        if (n == this.mContainer.count() - 1) {
            return null;
        }
        return this.mContainer.getItemByPos(n + 1);
    }

    @Override
    public boolean onTap(GeoPoint geoPoint, MapView mapView) {
        if (this.mContainer == null) {
            return false;
        }
        return this.mContainer.HandleTap(geoPoint, mapView);
    }

    @Override
    public void onEmptyTap(GeoPoint geoPoint) {
        super.onEmptyTap(geoPoint);
    }

    @Override
    public boolean onLongPress(GeoPoint geoPoint, MotionEvent motionEvent, MapView mapView) {
        if (this.mContainer == null) {
            return false;
        }
        this.mContainer.HandleLongPress(geoPoint, mapView);
        this.boLongPress = true;
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent, MapView mapView) {
        if (!this.boLongPress || this.itemSelected == null) {
            return false;
        }
        if (!((OverlayItem)this.itemSelected).isDragable()) {
            return false;
        }
        int n = 0;
        int n2 = motionEvent.getAction();
        switch (n2) {
            case 0: {
                break;
            }
            case 2: {
                n = (int)motionEvent.getX();
                int n3 = (int)motionEvent.getY();
                GeoPoint geoPoint = mapView.getProjection().fromPixels(n, n3);
                ((OverlayItem)this.itemSelected).setPoint(geoPoint);
                this.mapContext.c().invalidate();
                n = 1;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.boLongPress = false;
                this.itemSelected = null;
                n = 1;
            }
        }
        return n != 0;
    }

    protected boolean onTap(int n) {
        if (this.mContainer == null) {
            return false;
        }
        if (n != this.mCurFocus) {
            this.setFocus(this.getItem(n));
        }
        return false;
    }

    @Override
    public void draw(Canvas canvas, MapView mapView) {
        int n = this.size();
        if (n <= 0) {
            return;
        }
        Projection projection = mapView.getProjection();
        Object var5_5 = null;
        boolean bl = false;
        OverlayItem overlayItem = null;
        for (int i = 0; i < n; ++i) {
            Point point;
            try {
                int n2 = this.getIndexToDraw(i);
                overlayItem = (OverlayItem)this.getItem(n2);
            }
            catch (Exception exception) {
                continue;
            }
            if (overlayItem == null || (point = projection.toPixels(overlayItem.getPoint(), null)) == null) continue;
            if (this.boDrawShadow) {
                this.drawItem(canvas, mapView, true, overlayItem, point);
            }
            this.drawItem(canvas, mapView, false, overlayItem, point);
        }
        overlayItem = (OverlayItem)this.getFocus();
        if (this.mDrawFocusedItem && overlayItem != null) {
            Point point = projection.toPixels(overlayItem.getPoint(), null);
            if (this.boDrawShadow) {
                this.drawItem(canvas, mapView, true, overlayItem, point);
            }
            this.drawItem(canvas, mapView, false, overlayItem, point);
        }
    }

    static void drawShadow(Drawable drawable, Canvas canvas) {
        drawable.setColorFilter(0x7F000000, PorterDuff.Mode.SRC_IN);
        canvas.skew(-0.89f, 0.0f);
        canvas.scale(1.0f, 0.5f);
        drawable.draw(canvas);
        drawable.clearColorFilter();
    }

    private void drawItem(Canvas canvas, MapView mapView, boolean bl, Item Item, Point point) {
        mapView = ((OverlayItem)Item).getMarker();
        if (mapView == null) {
            mapView = this.defaultItemMarker;
        }
        if (bl) {
            canvas.save();
            canvas.translate((float)point.x, (float)point.y);
            ItemizedOverlay.drawShadow((Drawable)mapView, canvas);
            canvas.restore();
            return;
        }
        canvas.save();
        canvas.translate((float)point.x, (float)point.y);
        mapView.draw(canvas);
        canvas.restore();
    }

    class ItemsContainer
    implements Comparator<Integer> {
        private ArrayList<Item> mItems = new ArrayList();
        private ArrayList<Integer> drawIndex = new ArrayList();
        int iLatitudeCenter = 0;
        int iLongitudeCenter = 0;

        public ItemsContainer() {
            if (this.mItems != null) {
                this.mItems.clear();
            }
            if (this.drawIndex != null) {
                this.drawIndex.clear();
            }
            int n = 0;
            int n2 = 0;
            int n3 = ItemizedOverlay.this.size();
            for (int i = 0; i < n3; ++i) {
                this.drawIndex.add(i);
                Object Item = ItemizedOverlay.this.createItem(i);
                n += ((OverlayItem)Item).getPoint().getLatitudeE6();
                n2 += ((OverlayItem)Item).getPoint().getLongitudeE6();
                this.mItems.add(Item);
            }
            if (n3 > 0) {
                this.iLatitudeCenter = n / n3;
                this.iLongitudeCenter = n2 / n3;
            } else {
                this.iLatitudeCenter = 0;
                this.iLongitudeCenter = 0;
            }
            Collections.sort(this.drawIndex, this);
        }

        public int count() {
            return this.mItems.size();
        }

        public void release() {
            if (this.mItems != null) {
                this.mItems.clear();
            }
            if (this.drawIndex != null) {
                this.drawIndex.clear();
            }
        }

        @Override
        public int compare(Integer object, Integer object2) {
            object = ((OverlayItem)this.mItems.get((Integer)object)).getPoint();
            object2 = ((OverlayItem)this.mItems.get((Integer)object2)).getPoint();
            if (object == null || object2 == null) {
                return 0;
            }
            if (((GeoPoint)object).getLatitudeE6() > ((GeoPoint)object2).getLatitudeE6()) {
                return -1;
            }
            if (((GeoPoint)object).getLatitudeE6() < ((GeoPoint)object2).getLatitudeE6()) {
                return 1;
            }
            if (((GeoPoint)object).getLongitudeE6() < ((GeoPoint)object2).getLongitudeE6()) {
                return -1;
            }
            if (((GeoPoint)object).getLongitudeE6() > ((GeoPoint)object2).getLongitudeE6()) {
                return 1;
            }
            return 0;
        }

        public int getIndexByItem(Item Item) {
            int n = -1;
            int n2 = this.count();
            if (Item != null) {
                for (int i = 0; i < n2; ++i) {
                    if (!Item.equals(this.mItems.get(i))) continue;
                    n = i;
                    break;
                }
            }
            return n;
        }

        public Item getItemByPos(int n) {
            if (this.mItems == null) {
                return null;
            }
            int n2 = this.mItems.size();
            if (n2 <= n || n < 0) {
                return null;
            }
            return (OverlayItem)this.mItems.get(n);
        }

        public int getPosByRank(int n) {
            int n2 = this.drawIndex.size();
            if (n2 <= n) {
                return -1;
            }
            return this.drawIndex.get(n);
        }

        public int getSpan(boolean bl) {
            if (this.mItems.size() == 0) {
                return 0;
            }
            int n = Integer.MIN_VALUE;
            int n2 = Integer.MAX_VALUE;
            for (Object object : this.mItems) {
                object = ((OverlayItem)object).getPoint();
                int n3 = bl ? ((GeoPoint)object).getLatitudeE6() : ((GeoPoint)object).getLongitudeE6();
                if (n3 > n) {
                    n = n3;
                }
                if (n3 >= n2) continue;
                n2 = n3;
            }
            return n - n2;
        }

        public boolean HandleLongPress(GeoPoint geoPoint, MapView mapView) {
            int n = this.getHitItemIndex(geoPoint, mapView);
            if (n != -1) {
                ItemizedOverlay.this.itemSelected = (OverlayItem)this.mItems.get(n);
            }
            return false;
        }

        public boolean HandleTap(GeoPoint geoPoint, MapView mapView) {
            boolean bl = false;
            int n = this.getHitItemIndex(geoPoint, mapView);
            if (n >= 0) {
                bl = ItemizedOverlay.this.onTap(n);
            } else {
                ItemizedOverlay.this.setFocus(null);
            }
            mapView.postInvalidate();
            return bl;
        }

        private int getHitItemIndex(GeoPoint geoPoint, MapView object) {
            object = object.getProjection();
            geoPoint = ((Projection)object).toPixels(geoPoint, null);
            int n = -1;
            double d2 = Double.MAX_VALUE;
            int n2 = Integer.MAX_VALUE;
            boolean bl = false;
            int n3 = this.count();
            Object var5_7 = null;
            for (int i = 0; i < n3; ++i) {
                int n4;
                double d3;
                OverlayItem overlayItem = (OverlayItem)this.mItems.get(i);
                if (overlayItem == null) continue;
                double d4 = this.hitItemDis(overlayItem, (Projection)object, (Point)geoPoint, i);
                if (d3 >= 0.0 && d4 < d2) {
                    d2 = d4;
                    n2 = this.getPosByRank(i);
                    n = i;
                    continue;
                }
                if (d4 != d2 || (n4 = this.getPosByRank(i)) <= n2) continue;
                n = i;
            }
            return n;
        }

        private double hitItemDis(Item object, Projection projection, Point point, int n) {
            double d2 = -1.0;
            Point point2 = projection.toPixels(((OverlayItem)object).getPoint(), null);
            if (this.isItemHited(((OverlayItem)object).getMarker(), point2, projection, point, n)) {
                object = new Point(point.x - point2.x, point.y - point2.y);
                d2 = ((Point)object).x * ((Point)object).x + ((Point)object).y * ((Point)object).y;
            }
            return d2;
        }

        private boolean isItemHited(Drawable drawable, Point point, Projection projection, Point point2, int n) {
            point = new Point(point2.x - point.x, point2.y - point.y);
            if (drawable == null) {
                drawable = ItemizedOverlay.this.defaultItemMarker;
            }
            drawable = drawable.getBounds();
            return drawable.contains(point.x, point.y);
        }
    }

    public static interface OnFocusChangeListener {
        public void onFocusChanged(ItemizedOverlay<?> var1, OverlayItem var2);
    }

    static enum BoundPos {
        Normal,
        Center,
        CenterBottom;

    }
}

