/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ListView;
import com.tencent.mapsdk.raster.model.BitmapDescriptorFactory;
import com.tencent.mapsdk.raster.model.Circle;
import com.tencent.mapsdk.raster.model.CircleOptions;
import com.tencent.mapsdk.raster.model.GeoPoint;
import com.tencent.mapsdk.raster.model.GroundOverlay;
import com.tencent.mapsdk.raster.model.GroundOverlayOptions;
import com.tencent.mapsdk.raster.model.IOverlay;
import com.tencent.mapsdk.raster.model.LatLng;
import com.tencent.mapsdk.raster.model.LatLngBounds;
import com.tencent.mapsdk.raster.model.Marker;
import com.tencent.mapsdk.raster.model.MarkerOptions;
import com.tencent.mapsdk.raster.model.Polygon;
import com.tencent.mapsdk.raster.model.PolygonOptions;
import com.tencent.mapsdk.raster.model.Polyline;
import com.tencent.mapsdk.raster.model.PolylineOptions;
import com.tencent.mapsdk.rastercore.c;
import com.tencent.mapsdk.rastercore.d.e;
import com.tencent.mapsdk.rastercore.d.f;
import com.tencent.mapsdk.rastercore.f.a;
import com.tencent.tencentmap.mapsdk.map.CameraUpdate;
import com.tencent.tencentmap.mapsdk.map.MapActivity;
import com.tencent.tencentmap.mapsdk.map.MapController;
import com.tencent.tencentmap.mapsdk.map.Overlay;
import com.tencent.tencentmap.mapsdk.map.Projection;
import com.tencent.tencentmap.mapsdk.map.TencentMap;
import com.tencent.tencentmap.mapsdk.map.UiSettings;

public class MapView
extends FrameLayout {
    private e mapContext;
    private f eventHandler;
    private Projection projection;
    private TencentMap tencentMap;
    private UiSettings uiSettings;
    @Deprecated
    private MapController controller;

    public MapView(Context context) {
        super(context);
        this.init();
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    private void init() {
        this.initForBugly();
        Context context = this.getContext();
        this.mapContext = new e(this);
        this.eventHandler = this.mapContext.h();
        this.setOnKeyListener(this.eventHandler);
        this.projection = new Projection(this.mapContext);
        this.uiSettings = new UiSettings(this.mapContext.f());
        this.tencentMap = new TencentMap(this.mapContext);
        this.controller = new MapController(this);
        if (context instanceof MapActivity) {
            ((MapActivity)context).setMapView(this);
        }
        this.setBackgroundColor(-657936);
    }

    public void onCreate(Bundle bundle) {
        this.mapContext.a(bundle);
    }

    public void onResume() {
    }

    public void onPause() {
        MapView mapView = this;
        mapView.mapContext.n();
    }

    public void onSaveInstanceState(Bundle bundle) {
        this.mapContext.b(bundle);
    }

    public void onStop() {
    }

    public void onRestart() {
    }

    public void onDestroy() {
        this.mapContext.m();
    }

    public void onLowMemory() {
    }

    public void onDestroyView() {
    }

    public TencentMap getMap() {
        return this.tencentMap;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public UiSettings getUiSettings() {
        return this.uiSettings;
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        this.setClickable(false);
        this.eventHandler.b(MotionEvent.obtain((MotionEvent)motionEvent));
        this.getParent().requestDisallowInterceptTouchEvent(true);
        return super.dispatchTouchEvent(motionEvent) || this.eventHandler.a(motionEvent);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.layout(bl, n, n2, n3, n4);
    }

    public void layout() {
        this.layout(false, 0, 0, 0, 0);
    }

    private void layout(boolean n, int n2, int n3, int n4, int n5) {
        n = this.getChildCount();
        for (n2 = 0; n2 < n; ++n2) {
            View view = this.getChildAt(n2);
            if (view == null) continue;
            this.layout(view);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void layout(View view) {
        if (this != view.getParent()) return;
        if (!(view.getLayoutParams() instanceof LayoutParams)) {
            LayoutParams layoutParams = new LayoutParams(view.getLayoutParams());
            this.layoutView(view, layoutParams);
            return;
        }
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (layoutParams.mode == 0) {
            this.layoutMap(view, layoutParams);
            return;
        }
        this.layoutView(view, layoutParams);
    }

    private void layoutView(View view, LayoutParams layoutParams) {
        int[] nArray = new int[2];
        this.doMeasure(view, layoutParams.width, layoutParams.height, nArray);
        this.doLayout(view, nArray[0], nArray[1], layoutParams.x, layoutParams.y, layoutParams.alignment);
    }

    private void layoutMap(View view, LayoutParams layoutParams) {
        int[] nArray = new int[2];
        this.doMeasure(view, layoutParams.width, layoutParams.height, nArray);
        if (layoutParams.getPoint() != null) {
            PointF pointF = this.mapContext.b().a(layoutParams.getPoint());
            if (pointF == null) {
                return;
            }
            pointF.x += (float)layoutParams.x;
            pointF.y += (float)layoutParams.y;
            this.doLayout(view, nArray[0], nArray[1], pointF.x, pointF.y, layoutParams.alignment);
        }
    }

    private void doMeasure(View view, int n, int n2, int[] nArray) {
        View view2;
        if (view instanceof ListView && (view2 = (View)view.getParent()) != null) {
            nArray[0] = view2.getWidth();
            nArray[1] = view2.getHeight();
        }
        if (n <= 0 || n2 <= 0) {
            view.measure(0, 0);
        }
        nArray[0] = n == -2 ? view.getMeasuredWidth() : (n == -1 ? this.getMeasuredWidth() : n);
        if (n2 == -2) {
            nArray[1] = view.getMeasuredHeight();
            return;
        }
        if (n2 == -1) {
            nArray[1] = this.getMeasuredHeight();
            return;
        }
        nArray[1] = n2;
    }

    private void doLayout(View view, int n, int n2, float f2, float f3, int n3) {
        int n4 = n3 & 7;
        n3 &= 0x70;
        if (n4 == 5) {
            f2 -= (float)n;
        } else if (n4 == 1) {
            f2 -= (float)(n / 2);
        }
        if (n3 == 80) {
            f3 -= (float)n2;
        } else if (n3 == 16) {
            f3 -= (float)(n2 / 2);
        }
        int n5 = Math.round(f2);
        int n6 = Math.round(f3);
        view.layout(n5, n6, n5 + n, n6 + n2);
    }

    public void stopAnimation() {
        this.clearAnimation();
        this.mapContext.c().clearAnimation();
        this.eventHandler.b();
    }

    public void computeScroll() {
        super.computeScroll();
        this.eventHandler.a();
    }

    public LatLng getMapCenter() {
        return this.tencentMap.getMapCenter();
    }

    public MapController getController() {
        return this.controller;
    }

    public MapController getMapController() {
        return this.controller;
    }

    public void refreshMap() {
        this.postInvalidate();
    }

    public boolean isSatellite() {
        return this.tencentMap.isSatelliteEnabled();
    }

    public void setSatellite(boolean bl) {
        this.tencentMap.setSatelliteEnabled(bl);
    }

    public final boolean isAppKeyAvailable() {
        return this.tencentMap.isAppKeyAvailable();
    }

    public final String getVersion() {
        return this.tencentMap.getVersion();
    }

    public int getZoomLevel() {
        return this.tencentMap.getZoomLevel();
    }

    public int getMaxZoomLevel() {
        return this.tencentMap.getMaxZoomLevel();
    }

    public int getMinZoomLevel() {
        return this.tencentMap.getMinZoomLevel();
    }

    public int getLatitudeSpan() {
        return this.projection.getLatitudeSpan();
    }

    public int getLongitudeSpan() {
        return this.projection.getLongitudeSpan();
    }

    public final void removeOverlay(IOverlay iOverlay) {
        this.tencentMap.removeOverlay(iOverlay);
    }

    public final void clearAllOverlays() {
        this.tencentMap.clearAllOverlays();
    }

    public final boolean addOverlay(Overlay overlay) {
        if (overlay == null) {
            return false;
        }
        overlay.init(this);
        this.mapContext.e().a(overlay);
        return true;
    }

    public final Marker addMarker(MarkerOptions markerOptions) {
        return this.tencentMap.addMarker(markerOptions);
    }

    public Polyline addPolyline(PolylineOptions polylineOptions) {
        return this.tencentMap.addPolyline(polylineOptions);
    }

    public Circle addCircle(CircleOptions circleOptions) {
        return this.tencentMap.addCircle(circleOptions);
    }

    public Polygon addPolygon(PolygonOptions polygonOptions) {
        return this.tencentMap.addPolygon(polygonOptions);
    }

    public GroundOverlay addOverlay(Bitmap bitmap, LatLng latLng, LatLng latLng2) {
        return this.tencentMap.addGroundOverlay(new GroundOverlayOptions().positionFromBounds(new LatLngBounds(latLng, latLng2)).anchor(0.5f, 0.5f).transparency(0.1f).image(BitmapDescriptorFactory.fromBitmap(bitmap)));
    }

    public GroundOverlay addGroundOverlay(GroundOverlayOptions groundOverlayOptions) {
        return this.tencentMap.addGroundOverlay(groundOverlayOptions);
    }

    public void moveCamera(CameraUpdate cameraUpdate) {
        this.tencentMap.moveCamera(cameraUpdate);
    }

    public float getScalePerPixel() {
        return this.projection.getScalePerPixel();
    }

    public void setScalControlsEnable(boolean bl) {
        this.uiSettings.setScaleControlsEnabled(bl);
    }

    public void setScaleControlsEnable(boolean bl) {
        this.uiSettings.setScaleControlsEnabled(bl);
    }

    public void setPinchEnabeled(boolean bl) {
        this.uiSettings.setZoomGesturesEnabled(bl);
    }

    public void setScrollGesturesEnabled(boolean bl) {
        this.uiSettings.setScrollGesturesEnabled(bl);
    }

    public void setScaleViewPosition(int n) {
        this.uiSettings.setScaleViewPosition(n);
    }

    public void setLogoPosition(int n) {
        this.uiSettings.setLogoPosition(n);
    }

    protected e getMapContext() {
        return this.mapContext;
    }

    protected void setLocation(double d2, double d3) {
        c.b(d2, d3);
    }

    protected static void setIsChinese(boolean bl) {
        c.a(bl);
    }

    private void initForBugly() {
        Context context = this.getContext().getApplicationContext();
        context = context.getSharedPreferences("BuglySdkInfos", 0);
        context = context.edit();
        context.putString("4e7cb4aa49", "1.2.6");
        context.commit();
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        public static final int MODE_MAP = 0;
        public static final int MODE_VIEW = 1;
        public static final int LEFT = 3;
        public static final int RIGHT = 5;
        public static final int TOP = 48;
        public static final int BOTTOM = 80;
        public static final int CENTER_HORIZONTAL = 1;
        public static final int CENTER_VERTICAL = 16;
        public static final int CENTER = 17;
        public static final int TOP_LEFT = 51;
        public static final int BOTTOM_CENTER = 81;
        public int mode = 1;
        private int alignment = 51;
        private LatLng point = null;
        private int x = 0;
        private int y = 0;

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(int n, int n2, LatLng latLng, int n3) {
            this(n, n2, latLng, 0, 0, n3);
        }

        public LayoutParams(int n, int n2, LatLng latLng, int n3, int n4, int n5) {
            super(n, n2);
            this.mode = 0;
            this.setPoint(latLng);
            this.x = n3;
            this.y = n4;
            this.alignment = n5;
        }

        public LayoutParams(int n, int n2, GeoPoint geoPoint, int n3) {
            this(n, n2, geoPoint, 0, 0, n3);
        }

        public LayoutParams(int n, int n2, GeoPoint geoPoint, int n3, int n4, int n5) {
            this(n, n2, a.a(geoPoint), n3, n4, n5);
        }

        protected LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LatLng getPoint() {
            return this.point;
        }

        public void setPoint(LatLng latLng) {
            this.point = latLng;
        }
    }
}

