/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.map;

import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import com.tencent.mapsdk.raster.model.GeoPoint;
import com.tencent.tencentmap.mapsdk.map.ItemizedOverlay;

public class OverlayItem
implements Parcelable {
    protected GeoPoint mPoint;
    protected final String mTitle;
    protected final String mSnippet;
    private Drawable mMarker;
    protected boolean boDragable = true;
    public static final Parcelable.Creator<OverlayItem> CREATOR = new Parcelable.Creator<OverlayItem>(){

        public final OverlayItem createFromParcel(Parcel parcel) {
            return new OverlayItem(parcel);
        }

        public final OverlayItem[] newArray(int n) {
            return new OverlayItem[n];
        }
    };

    public OverlayItem(GeoPoint geoPoint, String string, String string2) {
        this.mPoint = geoPoint.Copy();
        this.mTitle = string;
        this.mSnippet = string2;
        this.mMarker = null;
    }

    protected OverlayItem(Parcel parcel) {
        this.mPoint = (GeoPoint)parcel.readValue(GeoPoint.class.getClassLoader());
        this.mTitle = parcel.readString();
        this.mSnippet = parcel.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mPoint);
        parcel.writeString(this.mTitle);
        parcel.writeString(this.mSnippet);
    }

    public void setDragable(boolean bl) {
        this.boDragable = bl;
    }

    public boolean isDragable() {
        return this.boDragable;
    }

    public Drawable getMarker() {
        return this.mMarker;
    }

    public void setMarker(Drawable drawable) {
        this.mMarker = drawable;
        if (this.mMarker == null) {
            return;
        }
        drawable = this.mMarker.getBounds();
        if (drawable == null) {
            ItemizedOverlay.boundCenterBottom(this.mMarker);
            return;
        }
        if (drawable.left == 0 && drawable.right == 0 && drawable.top == 0 && drawable.bottom == 0) {
            ItemizedOverlay.boundCenterBottom(this.mMarker);
        }
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getSnippet() {
        return this.mSnippet;
    }

    public GeoPoint getPoint() {
        return this.mPoint;
    }

    public void setPoint(GeoPoint geoPoint) {
        this.mPoint = geoPoint.Copy();
    }
}

